﻿using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace AZVIC.Ei8htPOS.POSRetail.Helpers
{
    public static class ExcelExportHelper
    {
        public static void Export(DataGrid gridView, string ReportName)
        {
            DataGridSelectionMode initialSelectioMode = gridView.SelectionMode;
            Clipboard.Clear();
            gridView.SelectionMode = DataGridSelectionMode.Extended;
            gridView.SelectAllCells();
            gridView.ClipboardCopyMode = DataGridClipboardCopyMode.IncludeHeader;
            ApplicationCommands.Copy.Execute(null, gridView);
            String resultat = (string)Clipboard.GetData(DataFormats.CommaSeparatedValue);
            String result = (string)Clipboard.GetData(DataFormats.Text);
            gridView.UnselectAllCells();
            gridView.SelectionMode = initialSelectioMode;

            // Configure save file dialog box
            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
            dlg.FileName = ReportName; // Default file name
            dlg.DefaultExt = ".xls"; // Default file extension
            dlg.Filter = "Excel documents (.xls)|*.xls"; // Filter files by extension 

            // Show save file dialog box
            Nullable<bool> result1 = dlg.ShowDialog();

            // Process save file dialog box results 
            if (result1 == true)
            {
                result = (result == null ? string.Empty : result);
                // Save document 
                string filename = dlg.FileName;
                System.IO.StreamWriter file = new System.IO.StreamWriter(filename);
                file.WriteLine(result.Replace(',', ' '));
                file.Close();
                MessageBox.Show("File exported to " + dlg.FileName + " successfully.");
            }

        }

        private static void ExportDataTable(DataTable dt, DateTime StartPeriod, DateTime EndPeriod,string FileName)
        {

            StringBuilder Table = new StringBuilder();
            Table.Append("<Table border='1' bgColor='#ffffff' " +
              "borderColor='#000000' cellSpacing='0' cellPadding='0' " +
              "style='font-size:10.0pt; font-family:Calibri; background:white;'> <TR>");
            //am getting my grid's column headers
            int columnscount = dt.Columns.Count;

            for (int j = 0; j < columnscount; j++)
            {      //write in new column
                Table.Append("<td><b>");
                Table.Append(dt.Columns[j].ColumnName);
                Table.Append("</b></td>");
            }
           Table.Append("</tr>");
            foreach (DataRow row in dt.Rows)
            {//write in new row
                Table.Append("<tr>");
                for (int i = 0; i < dt.Columns.Count; i++)
                {
                    Table.Append("<td>");
                    Table.Append(row[i].ToString());
                    Table.Append("</td></tr>");
                }
            }
            Table.Append("</Table>");
            // Configure save file dialog box
            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
            dlg.FileName = FileName; // Default file name
            dlg.DefaultExt = ".xls"; // Default file extension
            dlg.Filter = "Excel documents (.xls)|*.xls"; // Filter files by extension 
            // Show save file dialog box
            Nullable<bool> result1 = dlg.ShowDialog();
            
            // Process save file dialog box results 
            if (result1 == true)
            {
                string result = Table!=null ? Table.ToString() : string.Empty;
                // Save document 
                string filename = dlg.FileName;
                System.IO.StreamWriter file = new System.IO.StreamWriter(filename);
                file.WriteLine(result.Replace(',', ' '));
                file.Close();
                MessageBox.Show("File exported to " + dlg.FileName + " successfully.");
            }

        }

        public static void ExportDailySalesReport(List<Orders> TotalOrders, List<UserAccount> Users, IEnumerable<dynamic> InventoryReport, DateTime StartDate, DateTime EndDate, Dictionary<string, string> SalesInfo)
        {

            string TableHeader = "<table border=\"1\"><tr><td colspan=\"2\" align=\"center\"><b>Daily Sales Report</b></td></tr>" +
                "<tr><td colspan=\"2\" align=\"center\">" + StartDate.ToShortDateString() + "-" + EndDate.ToShortDateString() + "</td></tr>";

            foreach (var i in SalesInfo)
            {
                TableHeader += "<tr><td align=\"left\">" + i.Key + "</td><td align=\"right\">" + i.Value + "</td></tr>";
            }


            TableHeader += "<tr><td colspan=\"2\" align=\"left\" bgcolor=\"gray\"><b>Sales</b></td></tr>" +
            "<tr><td align=\"left\">Total Sales</td><td align=\"right\">" + TotalOrders.Sum(a => a.Total).ToString("$ 0.00") + "</td></tr>" +
                "<tr><td align=\"left\">Total Discount</td><td align=\"right\">" + TotalOrders.Sum(a => a.TotalDiscount + a.Discount + a.HappyHoursDiscount).ToString("$ 0.00") + "</td></tr>";

            TableHeader += "<tr><td colspan=\"2\" align=\"left\" bgcolor=\"gray\"><b>Income</b></td></tr>" + "<tr><td align=\"left\">Cash</td><td align=\"right\">" + TotalOrders.Where(a => a.PaymentMethod.ToLower().Equals("cash")).Sum(a => a.Total).ToString("$ 0.00") + "</td></tr>" +
                "<tr><td align=\"left\">Credit Card</td><td align=\"right\">" + TotalOrders.Where(a => a.PaymentMethod.ToLower().Equals("card")).Sum(a => a.Total).ToString("$ 0.00") + "</td></tr>" +
                "<tr><td align=\"left\">Nets</td><td align=\"right\">" + TotalOrders.Where(a => a.PaymentMethod.ToLower().Equals("nets")).Sum(a => a.Total).ToString("$ 0.00") + "</td></tr>";

            TableHeader += "<tr><td colspan=\"2\" align=\"left\" bgcolor=\"gray\"><b>Report</b></td></tr>" + "<tr><td align=\"left\">Order Count</td><td align=\"right\">" + TotalOrders.Count.ToString() + "</td></tr>" +
                "<tr><td align=\"left\">Submitted Order</td><td align=\"right\">" + TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("delivered")).Count().ToString() + "</td></tr>" +
                "<tr><td align=\"left\">Pending Order</td><td align=\"right\">" + TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("pending")).Count().ToString() + "</td></tr>" +
                "<tr><td align=\"left\">Void Orders</td><td align=\"right\">" + TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("canceled")).Count().ToString() + "</td></tr>";

            TableHeader += "<tr><td colspan=\"2\" align=\"left\" bgcolor=\"gray\"><b>User List</b></td></tr>" +
                "<tr><td align=\"left\">User</td><td align=\"right\">Sales Amount</td></tr>";

            var UserSales = from a in TotalOrders
                            group a by a.AdminUserAccountID into b
                            select new { UserID = b.Key, UserName = Users.Where(a => a.UniqueID == b.Key).Select(a => a.FirstName).Single(), Sales = TotalOrders.Where(a => a.AdminUserAccountID == b.Key).Sum(a => a.Total) };
            if (UserSales != null)
            {
                foreach (var i in UserSales)
                {
                    TableHeader += "<tr><td align=\"left\">" + i.UserName + "</td><td align=\"right\">" + i.Sales.ToString("$ 0.00") + "</td></tr>";
                }
                TableHeader += "<tr><td colspan=\"3\" align=\"left\" bgcolor=\"gray\"><b>Inventory Report</b></td></tr>" +
                       "<tr><td align=\"left\">Product Name</td><td align=\"right\">Items Sold</td><td align=\"right\">Actual Stock</td></tr>";
            }
            if (InventoryReport != null)
            {
                foreach (dynamic i in InventoryReport)
                {
                    TableHeader += "<tr><td align=\"left\">" + i.ProductName + "</td><td align=\"right\">" + i.ItemsSold + "</td></td><td align=\"right\">" + i.ActualStock + "</td></tr>";
                }
            }


            TableHeader += "</table>";

            // Configure save file dialog box
            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
            dlg.FileName = DateTime.Now.ToString("MMM_dd") + "_Sales_Report"; // Default file name
            dlg.DefaultExt = ".xls"; // Default file extension
            dlg.Filter = "Excel documents (.xls)|*.xls"; // Filter files by extension 

            // Show save file dialog box
            Nullable<bool> result1 = dlg.ShowDialog();

            // Process save file dialog box results 
            if (result1 == true)
            {
                // Save document 
                string filename = dlg.FileName;
                System.IO.StreamWriter file = new System.IO.StreamWriter(filename);
                file.WriteLine(TableHeader);
                file.Close();
                MessageBox.Show("Fie exported to " + dlg.FileName + " successfully.");
            }


        }
    }

}
